﻿Partial Public Class BitSelectDialog
    Inherits UserControl
    Private selectedBrush As Brush
    Private normalBrush As Brush
    Private txtblks(2, 8) As TextBlock

    Public Event ColorBitsChanged As EventHandler


    Public Sub New()
        InitializeComponent()

        ColorBits = New Integer(2) {}
        ColorBits(0) = 2
        ColorBits(1) = 2
        ColorBits(2) = 2

        selectedBrush = TryCast(Me.Resources("PhoneAccentBrush"), Brush)
        normalBrush = TryCast(Me.Resources("PhoneForegroundBrush"), Brush)
        Dim colors() = {"red", "green", "blue"}

        For col = 0 To 2
            Dim txtblk = New TextBlock With
                         {.Text = colors(col),
                          .FontWeight = FontWeights.Bold,
                          .TextAlignment = TextAlignment.Center,
                          .Margin = New Thickness(8, 2, 8, 2)}

            Grid.SetRow(txtblk, 0)
            Grid.SetColumn(txtblk, col)
            LayoutRoot.Children.Add(txtblk)

            For bit = 0 To 8
                txtblk = New TextBlock With
                         {.Text = bit.ToString(),
                          .Foreground = If(bit = ColorBits(col), selectedBrush, normalBrush),
                          .TextAlignment = TextAlignment.Center,
                          .Padding = New Thickness(2),
                          .Tag = col.ToString() & bit}

                Grid.SetRow(txtblk, bit + 1)
                Grid.SetColumn(txtblk, col)
                LayoutRoot.Children.Add(txtblk)

                txtblks(col, bit) = txtblk
            Next bit
        Next col
    End Sub


    Private _ColorBits As Integer()
    Public Property ColorBits() As Integer()
        Get
            Return _ColorBits
        End Get
        Protected Set(ByVal value As Integer())
            _ColorBits = value
        End Set
    End Property


    Public Sub Initialize(ByVal colorBits() As Integer)
        For clr = 0 To 2
            txtblks(clr, Me.ColorBits(clr)).Foreground = normalBrush
            Me.ColorBits(clr) = colorBits(clr)
            txtblks(clr, Me.ColorBits(clr)).Foreground = selectedBrush
        Next clr
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        If TypeOf args.OriginalSource Is TextBlock Then
            Dim txtblk = TryCast(args.OriginalSource, TextBlock)
            Dim tag = TryCast(txtblk.Tag, String)

            If tag IsNot Nothing AndAlso tag.Length = 2 Then
                Dim clr = Int32.Parse(tag.Chars(0).ToString())
                Dim bits = Int32.Parse(tag.Chars(1).ToString())

                If ColorBits(clr) <> bits Then
                    txtblks(clr, ColorBits(clr)).Foreground = normalBrush
                    ColorBits(clr) = bits
                    txtblks(clr, ColorBits(clr)).Foreground = selectedBrush

                    RaiseEvent ColorBitsChanged(Me, EventArgs.Empty)
                End If

                args.Complete()
                args.Handled = True
            End If
        End If
        MyBase.OnManipulationStarted(args)
    End Sub
End Class